package OOPLS;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MazeConfigurationDialog extends JDialog {
    JTextField rowsField = new JTextField();
    JTextField columnsField = new JTextField();
    JButton okayButton = new JButton("OK");
    MazePanel mp;
    int m, n;
    public MazeConfigurationDialog(MazePanel mp) {
        this.mp = mp;
        m = mp.getMaze().getNumRows();
        n = mp.getMaze().getNumColumns();
        setBounds(100,100,250,120);
        initComponents();
    }
    public void initComponents() {
        setLayout(
            new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(
            new BoxLayout(topPanel,BoxLayout.X_AXIS));
        topPanel.add(new JLabel("Number of Rows:          "));
        rowsField.setText(new Integer(m).toString());
        rowsField.setSelectionStart(0);
        rowsField.setSelectionEnd(3);
        topPanel.add(rowsField);
        getContentPane().add(topPanel);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(
            new BoxLayout(middlePanel,BoxLayout.X_AXIS));
        middlePanel.add(new JLabel("Number of Columns:    "));
        columnsField.setText(new Integer(n).toString());
        columnsField.setSelectionStart(0);
        columnsField.setSelectionEnd(2);
        middlePanel.add(columnsField);
        getContentPane().add(middlePanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(
            new BoxLayout(bottomPanel,BoxLayout.X_AXIS));
        bottomPanel.add(new JLabel(""));
        bottomPanel.add(okayButton);
        okayButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int newM = 
                    Integer.parseInt(rowsField.getText());
                int newN = 
                    Integer.parseInt(columnsField.getText());
                if (newM > 1 && newN > 1 && m != newM || 
                    n != newN) 
                    mp.newMaze(newM,newN);
                setVisible(false);
            } 
        });
        bottomPanel.add(new JLabel(""));
        getContentPane().add(bottomPanel);
    }
}
